/*
**	EPSG/POSC GCS Codes -> ERM datums
**
**
** [01] 06Nov02 maw Added NTF projection mapping
** [02] 11Nov03 dc	Added mapping for GDA94 datum
*/

struct gcs_erm_mapping {
    int gcs_code;
    char *datum;
};

/* Datums for which only the ellipsoid is known are not yet supported */

/* Standard datums only are supported at present */
static struct gcs_erm_mapping gcs_erm[] = {
/* From epsg_gcs.inc */
	{GCS_Adindan, "ADINDAN"},
	{GCS_AGD66, "AGD66"},
	{GCS_AGD84, "AGD84"},
	{GCS_Ain_el_Abd, "AINABD70"},
	{GCS_Afgooye, ""},
	{GCS_Agadez, ""},
	{GCS_Lisbon, "LISBON"},
	{GCS_Aratu, "ARATU"},
	{GCS_Arc_1950, "ARC1950"},
	{GCS_Arc_1960, "ARC1960"},
	{GCS_Batavia, "BATAVIA"},
	{GCS_Barbados, ""},
	{GCS_Beduaram, "BEDUARAM"},
	{GCS_Beijing_1954, "BEIJING"},
	{GCS_Belge_1950, ""},
	{GCS_Bermuda_1957, ""},
	{GCS_Bern_1898, "BERNNEW"},
	{GCS_Bogota, "BOGOTA"},
	{GCS_Bukit_Rimpah, ""},
	{GCS_Camacupa, "CAMACUPA"},
	{GCS_Campo_Inchauspe, "CMPOINCH"},
	{GCS_Cape, "CAPE"},
	{GCS_Carthage, "CARTHAGE"},
	{GCS_Chua, "CHUA"},
	{GCS_Corrego_Alegre, "CORRALEG"},
	{GCS_Cote_d_Ivoire, ""},
	{GCS_Deir_ez_Zor, "DEIR"},
	{GCS_Douala, ""},
	{GCS_Egypt_1907, "EGYPT07"},
	{GCS_ED50, "ED50"},
	{GCS_ED87, ""},
	{GCS_Fahud, "FAHUD"},
	{GCS_Gandajika_1970, ""},
	{GCS_Garoua, ""},
	{GCS_Guyane_Francaise, ""},
	{GCS_Hu_Tzu_Shan, ""},
	{GCS_HD72, ""},
	{GCS_ID74, "IND74"},
	{GCS_Indian_1954, "INDIAN54"},
	{GCS_Indian_1975, "INDIAN75"},
	{GCS_Jamaica_1875, "JA1875"},
	{GCS_JAD69, "JAD69"},
	{GCS_Kalianpur, "KALIANPR"},
	{GCS_Kandawala, ""},
	{GCS_Kertau, "KERTAU"},
	{GCS_KOC, "KOC"},
	{GCS_La_Canoa, "LACANOA"},
	{GCS_PSAD56, "PSAD56"},
	{GCS_Lake, ""},
	{GCS_Leigon, "LEIGON"},
	{GCS_Liberia_1964, ""},
	{GCS_Lome, ""},
	{GCS_Luzon_1911, "LUZON11"},
	{GCS_Hito_XVIII_1963, ""},
	{GCS_Herat_North, ""},
	{GCS_Mahe_1971, "MAHE71"},
	{GCS_Makassar, "MAKASSAR"},
	{GCS_EUREF89, ""},
	{GCS_Malongo_1987, ""},
	{GCS_Manoca, "MANOKA"},
	{GCS_Merchich, ""},
	{GCS_Massawa, ""},
	{GCS_Minna, "MINAA"},
	{GCS_Mhast, ""},
	{GCS_Monte_Mario, "MONTEMAR"},
	{GCS_M_poraloko, "MPORO"},
	{GCS_NAD27, "NAD27"},
	{GCS_NAD_Michigan, ""},
	{GCS_NAD83, "NAD83"},
	{GCS_Nahrwan_1967, "NAHRWAN"},
	{GCS_Naparima_1972, ""},
	{GCS_GD49, "NZGD49"},
	{GCS_NGO_1948, ""},
	{GCS_Datum_73, ""},
	{GCS_NTF, "NTF"}, // [01] //
	{GCS_NTF_Paris, "NTFPARIS"},
	{GCS_NSWC_9Z_2, ""},
	{GCS_OSGB_1936, "OSGB36"},
	{GCS_OSGB70, "OSGB70"},
	{GCS_OS_SN80, "OSSN80"},
	{GCS_Padang, "PADANG"},
	{GCS_Palestine_1923, "PALEST23"},
	{GCS_Pointe_Noire, "PTNOIRE"},
	{GCS_GDA94, "GDA94"},//[02]
	{GCS_Pulkovo_1942, "PULKOVO"},
	{GCS_Qatar, "QATAR"},
	{GCS_Qatar_1948, "QATAR51"},
	{GCS_Qornoq, "QORNOQ"},
	{GCS_Loma_Quintana, ""},
	{GCS_Amersfoort, "RD"},
	{GCS_RT38, ""},
	{GCS_SAD69, "SAD69"},
	{GCS_Sapper_Hill_1943, ""},
	{GCS_Schwarzeck, ""},
	{GCS_Segora, ""},
	{GCS_Serindung, ""},
	{GCS_Sudan, "SUDAN"},
	{GCS_Tananarive, "TANANAR"},
	{GCS_Timbalai_1948, "TIMBALAI"},
	{GCS_TM65, "TM65"},
	{GCS_TM75, "TM75"},
	{GCS_Tokyo, "TOKYO"},
	{GCS_Trinidad_1903, ""},
	{GCS_TC_1948, "TRUCIAL"},
	{GCS_Voirol_1875, ""},
	{GCS_Voirol_Unifie, ""},
	{GCS_Bern_1938, ""},
	{GCS_Nord_Sahara_1959, ""},
	{GCS_Stockholm_1938, ""},
	{GCS_Yacare, ""},
	{GCS_Yoff, "YOFF2000"},
	{GCS_Zanderij, ""},
	{GCS_MGI, ""},
	{GCS_Belge_1972, ""},
	{GCS_DHDN, ""},
	{GCS_Conakry_1905, ""},
	{GCS_WGS_72, "WGS72"},
	{GCS_WGS_72BE, "WGS72BE"},
	{GCS_WGS_84, "WGS84"},
	{GCS_Bern_1898_Bern, "BERNNEW"},
	{GCS_Bogota_Bogota, "BOGOTA"},
	{GCS_Lisbon_Lisbon, "LISBON"},
	{GCS_Makassar_Jakarta, ""},
	{GCS_MGI_Ferro, ""},
	{GCS_Monte_Mario_Rome, "MONTROME"},
	{GCS_NTF_Paris, "NTFPARIS"},
	{GCS_Padang_Jakarta, "PADANG"},
	{GCS_Belge_1950_Brussels, ""},
	{GCS_Tananarive_Paris, ""},
	{GCS_Voirol_1875_Paris, ""},
	{GCS_Voirol_Unifie_Paris, ""},
	{GCS_Batavia_Jakarta, "BATAVIA"},
	{GCS_ATF_Paris, ""},
	{GCS_NDG_Paris, ""},
	{GCSE_BesselNamibia, "NAMIBIA"},
/* From epsg_datum.inc */
	{Datum_Adindan, "ADINDAN"},
	{Datum_Australian_Geodetic_Datum_1966, "AGD66"},
	{Datum_Australian_Geodetic_Datum_1984, "AGD84"},
	{Datum_Ain_el_Abd_1970, "AINABD70"},
	{Datum_Afgooye, ""},
	{Datum_Agadez, ""},
	{Datum_Lisbon, "LISBON"},
	{Datum_Aratu, "ARATU"},
	{Datum_Arc_1950, "ARC1950"},
	{Datum_Arc_1960, "ARC1960"},
	{Datum_Batavia, "BATAVIA"},
	{Datum_Barbados, ""},
	{Datum_Beduaram, "BEDUARAM"},
	{Datum_Beijing_1954, "BEIJING"},
	{Datum_Reseau_National_Belge_1950, ""},
	{Datum_Bermuda_1957, ""},
	{Datum_Bern_1898, "BERNNEW"},
	{Datum_Bogota, "BOGOTA"},
	{Datum_Bukit_Rimpah, ""},
	{Datum_Camacupa, "CAMACUPA"},
	{Datum_Campo_Inchauspe, "CMPOINCH"},
	{Datum_Cape, "CAPE"},
	{Datum_Carthage, "CARTHAGE"},
	{Datum_Chua, "CHUA"},
	{Datum_Corrego_Alegre, "CORRALEG"},
	{Datum_Cote_d_Ivoire, ""},
	{Datum_Deir_ez_Zor, "DEIR"},
	{Datum_Douala, ""},
	{Datum_Egypt_1907, "EGYPT07"},
	{Datum_European_Datum_1950, "ED50"},
	{Datum_European_Datum_1987, ""},
	{Datum_Fahud, "FAHUD"},
	{Datum_Gandajika_1970, ""},
	{Datum_Garoua, ""},
	{Datum_Guyane_Francaise, ""},
	{Datum_Hu_Tzu_Shan, ""},
	{Datum_Hungarian_Datum_1972, ""},
	{Datum_Indonesian_Datum_1974, "IND74"},
	{Datum_Indian_1954, "INDIAN54"},
	{Datum_Indian_1975, "INDIAN75"},
	{Datum_Jamaica_1875, "JA1875"},
	{Datum_Jamaica_1969, "JAD69"},
	{Datum_Kalianpur, "KALIANPR"},
	{Datum_Kandawala, ""},
	{Datum_Kertau, "KERTAU"},
	{Datum_Kuwait_Oil_Company, "KOC"},
	{Datum_La_Canoa, "LACANOA"},
	{Datum_Provisional_S_American_Datum_1956, "PSAD56"},
	{Datum_Lake, ""},
	{Datum_Leigon, "LEIGON"},
	{Datum_Liberia_1964, ""},
	{Datum_Lome, ""},
	{Datum_Luzon_1911, "LUZON11"},
	{Datum_Hito_XVIII_1963, ""},
	{Datum_Herat_North, ""},
	{Datum_Mahe_1971, "MAHE71"},
	{Datum_Makassar, "MAKASSAR"},
	{Datum_European_Reference_System_1989, ""},
	{Datum_Malongo_1987, ""},
	{Datum_Manoca, "MANOKA"},
	{Datum_Merchich, ""},
	{Datum_Massawa, ""},
	{Datum_Minna, "MINAA"},
	{Datum_Mhast, ""},
	{Datum_Monte_Mario, "MONTEMAR"},
	{Datum_M_poraloko, "MPORO"},
	{Datum_North_American_Datum_1927, "NAD27"},
	{Datum_NAD_Michigan, ""},
	{Datum_North_American_Datum_1983, "NAD83"},
	{Datum_Nahrwan_1967, "NAHRWAN"},
	{Datum_Naparima_1972, ""},
	{Datum_New_Zealand_Geodetic_Datum_1949, "NZGD49"},
	{Datum_NGO_1948, ""},
	{Datum_Datum_73, ""},
	{Datum_Nouvelle_Triangulation_Francaise, ""},
	{Datum_NSWC_9Z_2, ""},
	{Datum_OSGB_1936, "OSGB36"},
	{Datum_OSGB_1970_SN, "OSGB70"},
	{Datum_OS_SN_1980, "OSSN80"},
	{Datum_Padang_1884, "PADANG"},
	{Datum_Palestine_1923, "PALEST23"},
	{Datum_Pointe_Noire, "PTNOIRE"},
	{Datum_Geocentric_Datum_of_Australia_1994, "GDA94"},//[02]
	{Datum_Pulkovo_1942, "PULKOVO"},
	{Datum_Qatar, "QATAR"},
	{Datum_Qatar_1948, "QATAR51"},
	{Datum_Qornoq, "QORNOQ"},
	{Datum_Loma_Quintana, ""},
	{Datum_Amersfoort, "RD"},
	{Datum_RT38, ""},
	{Datum_South_American_Datum_1969, "SAD69"},
	{Datum_Sapper_Hill_1943, ""},
	{Datum_Schwarzeck, ""},
	{Datum_Segora, ""},
	{Datum_Serindung, ""},
	{Datum_Sudan, "SUDAN"},
	{Datum_Tananarive_1925, "TANANAR"},
	{Datum_Timbalai_1948, "TIMBALAI"},
	{Datum_TM65, "TM65"},
	{Datum_TM75, "TM75"},
	{Datum_Tokyo, "TOKYO"},
	{Datum_Trinidad_1903, ""},
	{Datum_Trucial_Coast_1948, "TRUCIAL"},
	{Datum_Voirol_1875, ""},
	{Datum_Voirol_Unifie_1960, ""},
	{Datum_Bern_1938, ""},
	{Datum_Nord_Sahara_1959, ""},
	{Datum_Stockholm_1938, ""},
	{Datum_Yacare, ""},
	{Datum_Yoff, "YOFF2000"},
	{Datum_Zanderij, ""},
	{Datum_Militar_Geographische_Institut, ""},
	{Datum_Reseau_National_Belge_1972, ""},
	{Datum_Deutsche_Hauptdreiecksnetz, ""},
	{Datum_Conakry_1905, ""},
	{Datum_WGS72, "WGS72"},
	{Datum_WGS72_Transit_Broadcast_Ephemeris, ""},
	{Datum_WGS84, "WGS84"},
	{Datum_Ancienne_Triangulation_Francaise, ""},
	{Datum_Nord_de_Guerre, ""},
	{0, ""},
};
/* end of list */
